"use client"

import { useEffect, useState } from "react"

export function LoadingScreen() {
  const [progress, setProgress] = useState(0)
  const [isLoading, setIsLoading] = useState(true)
  const [shouldShow, setShouldShow] = useState(false)
  const [statusMessage, setStatusMessage] = useState("Loading resources...")

  useEffect(() => {
    const hasShown = sessionStorage.getItem("loadingScreenShown")

    if (hasShown) {
      setIsLoading(false)
      setShouldShow(false)
      return
    }

    setShouldShow(true)
    sessionStorage.setItem("loadingScreenShown", "true")

    const statusMessages = [
      "Loading resources...",
      "Starting scripts...",
      "Connecting to server...",
      "Loading complete",
    ]

    let messageIndex = 0
    const messageTimer = setInterval(() => {
      if (messageIndex < statusMessages.length - 1) {
        messageIndex++
        setStatusMessage(statusMessages[messageIndex])
      }
    }, 700)

    const duration = 2800
    const interval = 50
    const increment = 100 / (duration / interval)

    const timer = setInterval(() => {
      setProgress((prev) => {
        const next = prev + increment
        if (next >= 100) {
          clearInterval(timer)
          clearInterval(messageTimer)
          setStatusMessage("Loading complete")
          setTimeout(() => setIsLoading(false), 500)
          return 100
        }
        return next
      })
    }, interval)

    return () => {
      clearInterval(timer)
      clearInterval(messageTimer)
    }
  }, [])

  if (!shouldShow || !isLoading) return null

  return (
    <div
      className={`fixed inset-0 z-[9999] flex items-center justify-center bg-black transition-opacity duration-500 ${
        progress >= 100 ? "opacity-0 pointer-events-none" : "opacity-100"
      }`}
    >
      <div className="absolute inset-0 opacity-5">
        <div
          className="absolute inset-0"
          style={{
            backgroundImage: `repeating-linear-gradient(0deg, transparent, transparent 2px, #b7ff00 2px, #b7ff00 3px)`,
          }}
        />
      </div>

      <div className="relative flex flex-col items-center gap-12">
        <div className="flex flex-col items-center gap-3">
          <div
            className="text-6xl font-black tracking-tight text-[#b7ff00] italic"
            style={{
              textShadow: "0 0 20px rgba(183, 255, 0, 0.6)",
            }}
          >
            FUZE STUDIOS
          </div>
          <div className="h-1 w-48 bg-[#b7ff00] rounded-full" />
        </div>

        <div className="flex flex-col items-center gap-6 w-[500px]">
          <div className="w-full">
            <p className="text-base text-white/80 font-medium text-center tracking-wide">{statusMessage}</p>
          </div>

          <div className="w-full h-2 bg-white/10 rounded-full overflow-hidden">
            <div
              className="h-full bg-[#b7ff00] transition-all duration-300 ease-out"
              style={{
                width: `${progress}%`,
                boxShadow: "0 0 10px rgba(183, 255, 0, 0.8)",
              }}
            />
          </div>

          <p className="text-lg text-[#b7ff00] font-mono font-bold tracking-wider">{Math.round(progress)}%</p>
        </div>
      </div>
    </div>
  )
}
